package zio.aws.opensearchserverless
import zio.prelude.Subtype
import zio.aws.opensearchserverless.model.primitives.{
  SubnetId,
  SecurityGroupId,
  CollectionId,
  Resource,
  LifecycleResource,
  VpcEndpointId,
  CollectionName,
  TagKey
}
import zio.aws.opensearchserverless.model.primitives.SamlUserAttribute.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.opensearchserverless.model.primitives.Arn.Type
    object ClientToken extends Subtype[String]
    type ClientToken =
      zio.aws.opensearchserverless.model.primitives.ClientToken.Type
    object CollectionId extends Subtype[String]
    type CollectionId =
      zio.aws.opensearchserverless.model.primitives.CollectionId.Type
    object CollectionName extends Subtype[String]
    type CollectionName =
      zio.aws.opensearchserverless.model.primitives.CollectionName.Type
    object ConfigDescription extends Subtype[String]
    type ConfigDescription =
      zio.aws.opensearchserverless.model.primitives.ConfigDescription.Type
    object ConfigName extends Subtype[String]
    type ConfigName =
      zio.aws.opensearchserverless.model.primitives.ConfigName.Type
    object CreateCollectionRequestDescriptionString extends Subtype[String]
    type CreateCollectionRequestDescriptionString =
      zio.aws.opensearchserverless.model.primitives.CreateCollectionRequestDescriptionString.Type
    object IndexingCapacityValue extends Subtype[Int]
    type IndexingCapacityValue =
      zio.aws.opensearchserverless.model.primitives.IndexingCapacityValue.Type
    object LifecycleResource extends Subtype[String]
    type LifecycleResource =
      zio.aws.opensearchserverless.model.primitives.LifecycleResource.Type
    object ListAccessPoliciesRequestMaxResultsInteger extends Subtype[Int]
    type ListAccessPoliciesRequestMaxResultsInteger =
      zio.aws.opensearchserverless.model.primitives.ListAccessPoliciesRequestMaxResultsInteger.Type
    object ListCollectionsRequestMaxResultsInteger extends Subtype[Int]
    type ListCollectionsRequestMaxResultsInteger =
      zio.aws.opensearchserverless.model.primitives.ListCollectionsRequestMaxResultsInteger.Type
    object ListLifecyclePoliciesRequestMaxResultsInteger extends Subtype[Int]
    type ListLifecyclePoliciesRequestMaxResultsInteger =
      zio.aws.opensearchserverless.model.primitives.ListLifecyclePoliciesRequestMaxResultsInteger.Type
    object ListSecurityConfigsRequestMaxResultsInteger extends Subtype[Int]
    type ListSecurityConfigsRequestMaxResultsInteger =
      zio.aws.opensearchserverless.model.primitives.ListSecurityConfigsRequestMaxResultsInteger.Type
    object ListSecurityPoliciesRequestMaxResultsInteger extends Subtype[Int]
    type ListSecurityPoliciesRequestMaxResultsInteger =
      zio.aws.opensearchserverless.model.primitives.ListSecurityPoliciesRequestMaxResultsInteger.Type
    object ListVpcEndpointsRequestMaxResultsInteger extends Subtype[Int]
    type ListVpcEndpointsRequestMaxResultsInteger =
      zio.aws.opensearchserverless.model.primitives.ListVpcEndpointsRequestMaxResultsInteger.Type
    object PolicyDescription extends Subtype[String]
    type PolicyDescription =
      zio.aws.opensearchserverless.model.primitives.PolicyDescription.Type
    object PolicyDocument extends Subtype[String]
    type PolicyDocument =
      zio.aws.opensearchserverless.model.primitives.PolicyDocument.Type
    object PolicyName extends Subtype[String]
    type PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName.Type
    object PolicyVersion extends Subtype[String]
    type PolicyVersion =
      zio.aws.opensearchserverless.model.primitives.PolicyVersion.Type
    object Resource extends Subtype[String]
    type Resource = zio.aws.opensearchserverless.model.primitives.Resource.Type
    object ResourceName extends Subtype[String]
    type ResourceName =
      zio.aws.opensearchserverless.model.primitives.ResourceName.Type
    object SamlConfigOptionsSessionTimeoutInteger extends Subtype[Int]
    type SamlConfigOptionsSessionTimeoutInteger =
      zio.aws.opensearchserverless.model.primitives.SamlConfigOptionsSessionTimeoutInteger.Type
    object SamlGroupAttribute extends Subtype[String]
    type SamlGroupAttribute =
      zio.aws.opensearchserverless.model.primitives.SamlGroupAttribute.Type
    object SamlMetadata extends Subtype[String]
    type SamlMetadata =
      zio.aws.opensearchserverless.model.primitives.SamlMetadata.Type
    object SamlUserAttribute extends Subtype[String]
    type SamlUserAttribute =
      zio.aws.opensearchserverless.model.primitives.SamlUserAttribute.Type
    object SearchCapacityValue extends Subtype[Int]
    type SearchCapacityValue =
      zio.aws.opensearchserverless.model.primitives.SearchCapacityValue.Type
    object SecurityConfigId extends Subtype[String]
    type SecurityConfigId =
      zio.aws.opensearchserverless.model.primitives.SecurityConfigId.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.opensearchserverless.model.primitives.SecurityGroupId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.opensearchserverless.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.opensearchserverless.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.opensearchserverless.model.primitives.TagValue.Type
    object UpdateCollectionRequestDescriptionString extends Subtype[String]
    type UpdateCollectionRequestDescriptionString =
      zio.aws.opensearchserverless.model.primitives.UpdateCollectionRequestDescriptionString.Type
    object VpcEndpointId extends Subtype[String]
    type VpcEndpointId =
      zio.aws.opensearchserverless.model.primitives.VpcEndpointId.Type
    object VpcEndpointName extends Subtype[String]
    type VpcEndpointName =
      zio.aws.opensearchserverless.model.primitives.VpcEndpointName.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.opensearchserverless.model.primitives.VpcId.Type
  }
  type AccessPolicySummaries =
    List[zio.aws.opensearchserverless.model.AccessPolicySummary]
  type CollectionDetails =
    List[zio.aws.opensearchserverless.model.CollectionDetail]
  type CollectionErrorDetails =
    List[zio.aws.opensearchserverless.model.CollectionErrorDetail]
  type CollectionIds = List[CollectionId]
  type CollectionNames = List[CollectionName]
  type CollectionSummaries =
    List[zio.aws.opensearchserverless.model.CollectionSummary]
  type Document = software.amazon.awssdk.core.document.Document
  type EffectiveLifecyclePolicyDetails =
    List[zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail]
  type EffectiveLifecyclePolicyErrorDetails =
    List[zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail]
  type LifecyclePolicyDetails =
    List[zio.aws.opensearchserverless.model.LifecyclePolicyDetail]
  type LifecyclePolicyErrorDetails =
    List[zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail]
  type LifecyclePolicyIdentifiers =
    List[zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier]
  type LifecyclePolicyResourceIdentifiers =
    List[zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier]
  type LifecyclePolicySummaries =
    List[zio.aws.opensearchserverless.model.LifecyclePolicySummary]
  type ListAccessPoliciesRequestResourceList = List[Resource]
  type ListLifecyclePoliciesRequestResourcesList = List[LifecycleResource]
  type ListSecurityPoliciesRequestResourceList = List[Resource]
  type SecurityConfigSummaries =
    List[zio.aws.opensearchserverless.model.SecurityConfigSummary]
  type SecurityGroupIds = List[SecurityGroupId]
  type SecurityPolicySummaries =
    List[zio.aws.opensearchserverless.model.SecurityPolicySummary]
  type SubnetIds = List[SubnetId]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.opensearchserverless.model.Tag]
  type VpcEndpointDetails =
    List[zio.aws.opensearchserverless.model.VpcEndpointDetail]
  type VpcEndpointErrorDetails =
    List[zio.aws.opensearchserverless.model.VpcEndpointErrorDetail]
  type VpcEndpointIds = List[VpcEndpointId]
  type VpcEndpointSummaries =
    List[zio.aws.opensearchserverless.model.VpcEndpointSummary]
}
