package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LifecyclePolicyResourceIdentifier(
    resource: ResourceName,
    `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifier = {
    import LifecyclePolicyResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifier
      .builder()
      .resource(ResourceName.unwrap(resource): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier.ReadOnly =
    zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier
      .wrap(buildAwsValue())
}
object LifecyclePolicyResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier =
      zio.aws.opensearchserverless.model
        .LifecyclePolicyResourceIdentifier(resource, `type`)
    def resource: ResourceName
    def `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
    def getResource: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(resource)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifier
  ) extends zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier.ReadOnly {
    override val resource: ResourceName =
      zio.aws.opensearchserverless.model.primitives
        .ResourceName(impl.resource())
    override val `type`
        : zio.aws.opensearchserverless.model.LifecyclePolicyType =
      zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifier
  ): zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier.ReadOnly =
    new Wrapper(impl)
}
