package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.PolicyName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LifecyclePolicyIdentifier(
    name: PolicyName,
    `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifier = {
    import LifecyclePolicyIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifier
      .builder()
      .name(PolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.ReadOnly =
    zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier
      .wrap(buildAwsValue())
}
object LifecyclePolicyIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier =
      zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier(name, `type`)
    def name: PolicyName
    def `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifier
  ) extends zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.ReadOnly {
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val `type`
        : zio.aws.opensearchserverless.model.LifecyclePolicyType =
      zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifier
  ): zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.ReadOnly =
    new Wrapper(impl)
}
