package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.PolicyName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSecurityPolicyRequest(
    name: PolicyName,
    `type`: zio.aws.opensearchserverless.model.SecurityPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest = {
    import GetSecurityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest
      .builder()
      .name(PolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetSecurityPolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.GetSecurityPolicyRequest
      .wrap(buildAwsValue())
}
object GetSecurityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.GetSecurityPolicyRequest =
      zio.aws.opensearchserverless.model.GetSecurityPolicyRequest(name, `type`)
    def name: PolicyName
    def `type`: zio.aws.opensearchserverless.model.SecurityPolicyType
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.SecurityPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest
  ) extends zio.aws.opensearchserverless.model.GetSecurityPolicyRequest.ReadOnly {
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val `type`: zio.aws.opensearchserverless.model.SecurityPolicyType =
      zio.aws.opensearchserverless.model.SecurityPolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest
  ): zio.aws.opensearchserverless.model.GetSecurityPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
