package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityConfigStats(
    samlConfigCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigStats = {
    import SecurityConfigStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigStats
      .builder()
      .optionallyWith(samlConfigCount.map(value => value: java.lang.Long))(
        _.samlConfigCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.SecurityConfigStats.ReadOnly =
    zio.aws.opensearchserverless.model.SecurityConfigStats.wrap(buildAwsValue())
}
object SecurityConfigStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.SecurityConfigStats =
      zio.aws.opensearchserverless.model
        .SecurityConfigStats(samlConfigCount.map(value => value))
    def samlConfigCount: Optional[Long]
    def getSamlConfigCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("samlConfigCount", samlConfigCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigStats
  ) extends zio.aws.opensearchserverless.model.SecurityConfigStats.ReadOnly {
    override val samlConfigCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.samlConfigCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigStats
  ): zio.aws.opensearchserverless.model.SecurityConfigStats.ReadOnly =
    new Wrapper(impl)
}
