package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCollectionDetail(
    id: Optional[CollectionId] = Optional.Absent,
    name: Optional[CollectionName] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionDetail = {
    import DeleteCollectionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionDetail
      .builder()
      .optionallyWith(
        id.map(value => CollectionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteCollectionDetail.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteCollectionDetail
      .wrap(buildAwsValue())
}
object DeleteCollectionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.DeleteCollectionDetail =
      zio.aws.opensearchserverless.model.DeleteCollectionDetail(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def id: Optional[CollectionId]
    def name: Optional[CollectionName]
    def status: Optional[zio.aws.opensearchserverless.model.CollectionStatus]
    def getId: ZIO[Any, AwsError, CollectionId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionDetail
  ) extends zio.aws.opensearchserverless.model.DeleteCollectionDetail.ReadOnly {
    override val id: Optional[CollectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionId(value)
      )
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionName(value)
      )
    override val status
        : Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionDetail
  ): zio.aws.opensearchserverless.model.DeleteCollectionDetail.ReadOnly =
    new Wrapper(impl)
}
