package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.{
  Resource,
  ListSecurityPoliciesRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSecurityPoliciesRequest(
    maxResults: Optional[ListSecurityPoliciesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    resource: Optional[Iterable[Resource]] = Optional.Absent,
    `type`: zio.aws.opensearchserverless.model.SecurityPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest = {
    import ListSecurityPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSecurityPoliciesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        resource.map(value =>
          value.map { item =>
            Resource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resource)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListSecurityPoliciesRequest.ReadOnly =
    zio.aws.opensearchserverless.model.ListSecurityPoliciesRequest
      .wrap(buildAwsValue())
}
object ListSecurityPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListSecurityPoliciesRequest =
      zio.aws.opensearchserverless.model.ListSecurityPoliciesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resource.map(value => value),
        `type`
      )
    def maxResults: Optional[ListSecurityPoliciesRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def resource: Optional[List[Resource]]
    def `type`: zio.aws.opensearchserverless.model.SecurityPolicyType
    def getMaxResults
        : ZIO[Any, AwsError, ListSecurityPoliciesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResource: ZIO[Any, AwsError, List[Resource]] =
      AwsError.unwrapOptionField("resource", resource)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.SecurityPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest
  ) extends zio.aws.opensearchserverless.model.ListSecurityPoliciesRequest.ReadOnly {
    override val maxResults
        : Optional[ListSecurityPoliciesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .ListSecurityPoliciesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resource: Optional[List[Resource]] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.Resource(item)
        }.toList
      )
    override val `type`: zio.aws.opensearchserverless.model.SecurityPolicyType =
      zio.aws.opensearchserverless.model.SecurityPolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest
  ): zio.aws.opensearchserverless.model.ListSecurityPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
