package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  VpcEndpointName,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcEndpointSummary(
    id: Optional[VpcEndpointId] = Optional.Absent,
    name: Optional[VpcEndpointName] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary = {
    import VpcEndpointSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary
      .builder()
      .optionallyWith(
        id.map(value => VpcEndpointId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => VpcEndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.VpcEndpointSummary.ReadOnly =
    zio.aws.opensearchserverless.model.VpcEndpointSummary.wrap(buildAwsValue())
}
object VpcEndpointSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.VpcEndpointSummary =
      zio.aws.opensearchserverless.model.VpcEndpointSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def id: Optional[VpcEndpointId]
    def name: Optional[VpcEndpointName]
    def status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus]
    def getId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, VpcEndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.VpcEndpointStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary
  ) extends zio.aws.opensearchserverless.model.VpcEndpointSummary.ReadOnly {
    override val id: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointId(value)
      )
    override val name: Optional[VpcEndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointName(value)
      )
    override val status
        : Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.VpcEndpointStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary
  ): zio.aws.opensearchserverless.model.VpcEndpointSummary.ReadOnly =
    new Wrapper(impl)
}
