package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCollectionResponse(
    updateCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.UpdateCollectionDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse = {
    import UpdateCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse
      .builder()
      .optionallyWith(
        updateCollectionDetail.map(value => value.buildAwsValue())
      )(_.updateCollectionDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateCollectionResponse
      .wrap(buildAwsValue())
}
object UpdateCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateCollectionResponse =
      zio.aws.opensearchserverless.model.UpdateCollectionResponse(
        updateCollectionDetail.map(value => value.asEditable)
      )
    def updateCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.UpdateCollectionDetail.ReadOnly
    ]
    def getUpdateCollectionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.UpdateCollectionDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateCollectionDetail",
      updateCollectionDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse
  ) extends zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly {
    override val updateCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.UpdateCollectionDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateCollectionDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.UpdateCollectionDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse
  ): zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
