package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters._
sealed trait CollectionType {
  def unwrap: software.amazon.awssdk.services.opensearchserverless.model.CollectionType
}
object CollectionType {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.CollectionType
  ): zio.aws.opensearchserverless.model.CollectionType = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionType.SEARCH =>
      val r = SEARCH
      r
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionType.TIMESERIES =>
      val r = TIMESERIES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionType =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SEARCH extends zio.aws.opensearchserverless.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionType =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionType.SEARCH
  }
  case object TIMESERIES
      extends zio.aws.opensearchserverless.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionType =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionType.TIMESERIES
  }
}
