package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.VpcEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcEndpointErrorDetail(
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    id: Optional[VpcEndpointId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail = {
    import VpcEndpointErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(
        id.map(value => VpcEndpointId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.ReadOnly =
    zio.aws.opensearchserverless.model.VpcEndpointErrorDetail
      .wrap(buildAwsValue())
}
object VpcEndpointErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.VpcEndpointErrorDetail =
      zio.aws.opensearchserverless.model.VpcEndpointErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        id.map(value => value)
      )
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def id: Optional[VpcEndpointId]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail
  ) extends zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.ReadOnly {
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val id: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail
  ): zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.ReadOnly =
    new Wrapper(impl)
}
