package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  SecurityConfigId,
  ConfigDescription,
  PolicyVersion,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityConfigRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    configVersion: PolicyVersion,
    description: Optional[ConfigDescription] = Optional.Absent,
    id: SecurityConfigId,
    samlOptions: Optional[
      zio.aws.opensearchserverless.model.SamlConfigOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest = {
    import UpdateSecurityConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .configVersion(PolicyVersion.unwrap(configVersion): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConfigDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .id(SecurityConfigId.unwrap(id): java.lang.String)
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateSecurityConfigRequest.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateSecurityConfigRequest
      .wrap(buildAwsValue())
}
object UpdateSecurityConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateSecurityConfigRequest =
      zio.aws.opensearchserverless.model.UpdateSecurityConfigRequest(
        clientToken.map(value => value),
        configVersion,
        description.map(value => value),
        id,
        samlOptions.map(value => value.asEditable)
      )
    def clientToken: Optional[ClientToken]
    def configVersion: PolicyVersion
    def description: Optional[ConfigDescription]
    def id: SecurityConfigId
    def samlOptions: Optional[
      zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly
    ]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfigVersion: ZIO[Any, Nothing, PolicyVersion] =
      ZIO.succeed(configVersion)
    def getDescription: ZIO[Any, AwsError, ConfigDescription] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, SecurityConfigId] = ZIO.succeed(id)
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest
  ) extends zio.aws.opensearchserverless.model.UpdateSecurityConfigRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val configVersion: PolicyVersion =
      zio.aws.opensearchserverless.model.primitives
        .PolicyVersion(impl.configVersion())
    override val description: Optional[ConfigDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.ConfigDescription(value)
        )
    override val id: SecurityConfigId =
      zio.aws.opensearchserverless.model.primitives.SecurityConfigId(impl.id())
    override val samlOptions: Optional[
      zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.samlOptions())
      .map(value =>
        zio.aws.opensearchserverless.model.SamlConfigOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest
  ): zio.aws.opensearchserverless.model.UpdateSecurityConfigRequest.ReadOnly =
    new Wrapper(impl)
}
