package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetVpcEndpointResponse(
    vpcEndpointDetails: Optional[
      Iterable[zio.aws.opensearchserverless.model.VpcEndpointDetail]
    ] = Optional.Absent,
    vpcEndpointErrorDetails: Optional[
      Iterable[zio.aws.opensearchserverless.model.VpcEndpointErrorDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse = {
    import BatchGetVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse
      .builder()
      .optionallyWith(
        vpcEndpointDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpointDetails)
      .optionallyWith(
        vpcEndpointErrorDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpointErrorDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse
      .wrap(buildAwsValue())
}
object BatchGetVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse =
      zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse(
        vpcEndpointDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpointErrorDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcEndpointDetails: Optional[
      List[zio.aws.opensearchserverless.model.VpcEndpointDetail.ReadOnly]
    ]
    def vpcEndpointErrorDetails: Optional[
      List[zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.ReadOnly]
    ]
    def getVpcEndpointDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.VpcEndpointDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcEndpointDetails", vpcEndpointDetails)
    def getVpcEndpointErrorDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcEndpointErrorDetails",
      vpcEndpointErrorDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse
  ) extends zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly {
    override val vpcEndpointDetails: Optional[
      List[zio.aws.opensearchserverless.model.VpcEndpointDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.VpcEndpointDetail.wrap(item)
        }.toList
      )
    override val vpcEndpointErrorDetails: Optional[
      List[zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointErrorDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.VpcEndpointErrorDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse
  ): zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
