package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters._
sealed trait SecurityConfigType {
  def unwrap: software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType
}
object SecurityConfigType {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType
  ): zio.aws.opensearchserverless.model.SecurityConfigType = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType.SAML =>
      val r = saml
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.SecurityConfigType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType =
      software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType.UNKNOWN_TO_SDK_VERSION
  }
  case object saml
      extends zio.aws.opensearchserverless.model.SecurityConfigType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType =
      software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType.SAML
  }
}
