package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountSettingsResponse(
    accountSettingsDetail: Optional[
      zio.aws.opensearchserverless.model.AccountSettingsDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(
        accountSettingsDetail.map(value => value.buildAwsValue())
      )(_.accountSettingsDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.opensearchserverless.model.GetAccountSettingsResponse
      .wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.GetAccountSettingsResponse =
      zio.aws.opensearchserverless.model.GetAccountSettingsResponse(
        accountSettingsDetail.map(value => value.asEditable)
      )
    def accountSettingsDetail: Optional[
      zio.aws.opensearchserverless.model.AccountSettingsDetail.ReadOnly
    ]
    def getAccountSettingsDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.AccountSettingsDetail.ReadOnly
    ] =
      AwsError.unwrapOptionField("accountSettingsDetail", accountSettingsDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse
  ) extends zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly {
    override val accountSettingsDetail: Optional[
      zio.aws.opensearchserverless.model.AccountSettingsDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountSettingsDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.AccountSettingsDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse
  ): zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
