package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  SubnetId,
  VpcId,
  SecurityGroupId,
  VpcEndpointId,
  VpcEndpointName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcEndpointDetail(
    createdDate: Optional[Long] = Optional.Absent,
    id: Optional[VpcEndpointId] = Optional.Absent,
    name: Optional[VpcEndpointName] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail = {
    import VpcEndpointDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail
      .builder()
      .optionallyWith(createdDate.map(value => value: java.lang.Long))(
        _.createdDate
      )
      .optionallyWith(
        id.map(value => VpcEndpointId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => VpcEndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.VpcEndpointDetail.ReadOnly =
    zio.aws.opensearchserverless.model.VpcEndpointDetail.wrap(buildAwsValue())
}
object VpcEndpointDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.VpcEndpointDetail =
      zio.aws.opensearchserverless.model.VpcEndpointDetail(
        createdDate.map(value => value),
        id.map(value => value),
        name.map(value => value),
        securityGroupIds.map(value => value),
        status.map(value => value),
        subnetIds.map(value => value),
        vpcId.map(value => value)
      )
    def createdDate: Optional[Long]
    def id: Optional[VpcEndpointId]
    def name: Optional[VpcEndpointName]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus]
    def subnetIds: Optional[List[SubnetId]]
    def vpcId: Optional[VpcId]
    def getCreatedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, VpcEndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.VpcEndpointStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail
  ) extends zio.aws.opensearchserverless.model.VpcEndpointDetail.ReadOnly {
    override val createdDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: Long)
    override val id: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointId(value)
      )
    override val name: Optional[VpcEndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointName(value)
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val status
        : Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.VpcEndpointStatus.wrap(value)
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.opensearchserverless.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail
  ): zio.aws.opensearchserverless.model.VpcEndpointDetail.ReadOnly =
    new Wrapper(impl)
}
