package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CollectionSummary(
    arn: Optional[String] = Optional.Absent,
    id: Optional[CollectionId] = Optional.Absent,
    name: Optional[CollectionName] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CollectionSummary = {
    import CollectionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CollectionSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        id.map(value => CollectionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CollectionSummary.ReadOnly =
    zio.aws.opensearchserverless.model.CollectionSummary.wrap(buildAwsValue())
}
object CollectionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CollectionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.CollectionSummary =
      zio.aws.opensearchserverless.model.CollectionSummary(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[String]
    def id: Optional[CollectionId]
    def name: Optional[CollectionName]
    def status: Optional[zio.aws.opensearchserverless.model.CollectionStatus]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, CollectionId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionSummary
  ) extends zio.aws.opensearchserverless.model.CollectionSummary.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[CollectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionId(value)
      )
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionName(value)
      )
    override val status
        : Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionSummary
  ): zio.aws.opensearchserverless.model.CollectionSummary.ReadOnly =
    new Wrapper(impl)
}
