package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters._
sealed trait VpcEndpointStatus {
  def unwrap: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus
}
object VpcEndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus
  ): zio.aws.opensearchserverless.model.VpcEndpointStatus = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus =
      software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.opensearchserverless.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus =
      software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.PENDING
  }
  case object DELETING
      extends zio.aws.opensearchserverless.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus =
      software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.DELETING
  }
  case object ACTIVE
      extends zio.aws.opensearchserverless.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus =
      software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.ACTIVE
  }
  case object FAILED
      extends zio.aws.opensearchserverless.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus =
      software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointStatus.FAILED
  }
}
