package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  PolicyVersion,
  PolicyName,
  PolicyDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccessPolicyDetail(
    createdDate: Optional[Long] = Optional.Absent,
    description: Optional[PolicyDescription] = Optional.Absent,
    lastModifiedDate: Optional[Long] = Optional.Absent,
    name: Optional[PolicyName] = Optional.Absent,
    policy: Optional[zio.aws.opensearchserverless.model.Document] =
      Optional.Absent,
    policyVersion: Optional[PolicyVersion] = Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.AccessPolicyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyDetail = {
    import AccessPolicyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyDetail
      .builder()
      .optionallyWith(createdDate.map(value => value: java.lang.Long))(
        _.createdDate
      )
      .optionallyWith(
        description.map(value =>
          PolicyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.Long))(
        _.lastModifiedDate
      )
      .optionallyWith(
        name.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(policy.map(value => value))(_.policy)
      .optionallyWith(
        policyVersion.map(value =>
          PolicyVersion.unwrap(value): java.lang.String
        )
      )(_.policyVersion)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly =
    zio.aws.opensearchserverless.model.AccessPolicyDetail.wrap(buildAwsValue())
}
object AccessPolicyDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.AccessPolicyDetail =
      zio.aws.opensearchserverless.model.AccessPolicyDetail(
        createdDate.map(value => value),
        description.map(value => value),
        lastModifiedDate.map(value => value),
        name.map(value => value),
        policy.map(value => value),
        policyVersion.map(value => value),
        `type`.map(value => value)
      )
    def createdDate: Optional[Long]
    def description: Optional[PolicyDescription]
    def lastModifiedDate: Optional[Long]
    def name: Optional[PolicyName]
    def policy: Optional[software.amazon.awssdk.core.document.Document]
    def policyVersion: Optional[PolicyVersion]
    def `type`: Optional[zio.aws.opensearchserverless.model.AccessPolicyType]
    def getCreatedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("name", name)
    def getPolicy
        : ZIO[Any, AwsError, software.amazon.awssdk.core.document.Document] =
      AwsError.unwrapOptionField("policy", policy)
    def getPolicyVersion: ZIO[Any, AwsError, PolicyVersion] =
      AwsError.unwrapOptionField("policyVersion", policyVersion)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.AccessPolicyType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyDetail
  ) extends zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly {
    override val createdDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: Long)
    override val description: Optional[PolicyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.PolicyDescription(value)
        )
    override val lastModifiedDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: Long)
    override val name: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.PolicyName(value)
      )
    override val policy
        : Optional[software.amazon.awssdk.core.document.Document] =
      zio.aws.core.internal.optionalFromNullable(impl.policy())
    override val policyVersion: Optional[PolicyVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.policyVersion())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.PolicyVersion(value)
      )
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.AccessPolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.AccessPolicyType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyDetail
  ): zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly =
    new Wrapper(impl)
}
