package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionId,
  UpdateCollectionRequestDescriptionString,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCollectionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[UpdateCollectionRequestDescriptionString] =
      Optional.Absent,
    id: CollectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest = {
    import UpdateCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          UpdateCollectionRequestDescriptionString.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .id(CollectionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateCollectionRequest.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateCollectionRequest
      .wrap(buildAwsValue())
}
object UpdateCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.UpdateCollectionRequest =
      zio.aws.opensearchserverless.model.UpdateCollectionRequest(
        clientToken.map(value => value),
        description.map(value => value),
        id
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[UpdateCollectionRequestDescriptionString]
    def id: CollectionId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription
        : ZIO[Any, AwsError, UpdateCollectionRequestDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, CollectionId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest
  ) extends zio.aws.opensearchserverless.model.UpdateCollectionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val description
        : Optional[UpdateCollectionRequestDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .UpdateCollectionRequestDescriptionString(value)
        )
    override val id: CollectionId =
      zio.aws.opensearchserverless.model.primitives.CollectionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest
  ): zio.aws.opensearchserverless.model.UpdateCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
