package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters._
sealed trait SecurityPolicyType {
  def unwrap: software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType
}
object SecurityPolicyType {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType
  ): zio.aws.opensearchserverless.model.SecurityPolicyType = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType.ENCRYPTION =>
      val r = encryption
      r
    case software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType.NETWORK =>
      val r = network
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.SecurityPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType =
      software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object encryption
      extends zio.aws.opensearchserverless.model.SecurityPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType =
      software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType.ENCRYPTION
  }
  case object network
      extends zio.aws.opensearchserverless.model.SecurityPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType =
      software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType.NETWORK
  }
}
