package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.CollectionName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CollectionFilters(
    name: Optional[CollectionName] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CollectionFilters = {
    import CollectionFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CollectionFilters
      .builder()
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CollectionFilters.ReadOnly =
    zio.aws.opensearchserverless.model.CollectionFilters.wrap(buildAwsValue())
}
object CollectionFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CollectionFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.CollectionFilters =
      zio.aws.opensearchserverless.model
        .CollectionFilters(name.map(value => value), status.map(value => value))
    def name: Optional[CollectionName]
    def status: Optional[zio.aws.opensearchserverless.model.CollectionStatus]
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionFilters
  ) extends zio.aws.opensearchserverless.model.CollectionFilters.ReadOnly {
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionName(value)
      )
    override val status
        : Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionFilters
  ): zio.aws.opensearchserverless.model.CollectionFilters.ReadOnly =
    new Wrapper(impl)
}
