package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointsResponse(
    nextToken: Optional[String] = Optional.Absent,
    vpcEndpointSummaries: Optional[
      Iterable[zio.aws.opensearchserverless.model.VpcEndpointSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse = {
    import ListVpcEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        vpcEndpointSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpointSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly =
    zio.aws.opensearchserverless.model.ListVpcEndpointsResponse
      .wrap(buildAwsValue())
}
object ListVpcEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListVpcEndpointsResponse =
      zio.aws.opensearchserverless.model.ListVpcEndpointsResponse(
        nextToken.map(value => value),
        vpcEndpointSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def vpcEndpointSummaries: Optional[
      List[zio.aws.opensearchserverless.model.VpcEndpointSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcEndpointSummaries: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.VpcEndpointSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("vpcEndpointSummaries", vpcEndpointSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse
  ) extends zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val vpcEndpointSummaries: Optional[
      List[zio.aws.opensearchserverless.model.VpcEndpointSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.VpcEndpointSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse
  ): zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
