package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CollectionErrorDetail(
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    id: Optional[CollectionId] = Optional.Absent,
    name: Optional[CollectionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail = {
    import CollectionErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(
        id.map(value => CollectionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CollectionErrorDetail.ReadOnly =
    zio.aws.opensearchserverless.model.CollectionErrorDetail
      .wrap(buildAwsValue())
}
object CollectionErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.CollectionErrorDetail =
      zio.aws.opensearchserverless.model.CollectionErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def id: Optional[CollectionId]
    def name: Optional[CollectionName]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getId: ZIO[Any, AwsError, CollectionId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail
  ) extends zio.aws.opensearchserverless.model.CollectionErrorDetail.ReadOnly {
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val id: Optional[CollectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionId(value)
      )
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail
  ): zio.aws.opensearchserverless.model.CollectionErrorDetail.ReadOnly =
    new Wrapper(impl)
}
