package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCollectionsResponse(
    collectionSummaries: Optional[
      Iterable[zio.aws.opensearchserverless.model.CollectionSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse = {
    import ListCollectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse
      .builder()
      .optionallyWith(
        collectionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collectionSummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly =
    zio.aws.opensearchserverless.model.ListCollectionsResponse
      .wrap(buildAwsValue())
}
object ListCollectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.ListCollectionsResponse =
      zio.aws.opensearchserverless.model.ListCollectionsResponse(
        collectionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def collectionSummaries: Optional[
      List[zio.aws.opensearchserverless.model.CollectionSummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getCollectionSummaries: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.CollectionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("collectionSummaries", collectionSummaries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse
  ) extends zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly {
    override val collectionSummaries: Optional[
      List[zio.aws.opensearchserverless.model.CollectionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.CollectionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse
  ): zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly =
    new Wrapper(impl)
}
