package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccessPoliciesResponse(
    accessPolicySummaries: Optional[
      Iterable[zio.aws.opensearchserverless.model.AccessPolicySummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse = {
    import ListAccessPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse
      .builder()
      .optionallyWith(
        accessPolicySummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessPolicySummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly =
    zio.aws.opensearchserverless.model.ListAccessPoliciesResponse
      .wrap(buildAwsValue())
}
object ListAccessPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListAccessPoliciesResponse =
      zio.aws.opensearchserverless.model.ListAccessPoliciesResponse(
        accessPolicySummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accessPolicySummaries: Optional[
      List[zio.aws.opensearchserverless.model.AccessPolicySummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getAccessPolicySummaries: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.AccessPolicySummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("accessPolicySummaries", accessPolicySummaries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse
  ) extends zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly {
    override val accessPolicySummaries: Optional[
      List[zio.aws.opensearchserverless.model.AccessPolicySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPolicySummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.AccessPolicySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse
  ): zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
