package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityPolicyResponse(
    securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse = {
    import UpdateSecurityPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse
      .builder()
      .optionallyWith(securityPolicyDetail.map(value => value.buildAwsValue()))(
        _.securityPolicyDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse
      .wrap(buildAwsValue())
}
object UpdateSecurityPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse =
      zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse(
        securityPolicyDetail.map(value => value.asEditable)
      )
    def securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ]
    def getSecurityPolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ] = AwsError.unwrapOptionField("securityPolicyDetail", securityPolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse
  ) extends zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse.ReadOnly {
    override val securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityPolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityPolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse
  ): zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
