package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityConfigResponse(
    securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse = {
    import UpdateSecurityConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse
      .builder()
      .optionallyWith(securityConfigDetail.map(value => value.buildAwsValue()))(
        _.securityConfigDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse
      .wrap(buildAwsValue())
}
object UpdateSecurityConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse =
      zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse(
        securityConfigDetail.map(value => value.asEditable)
      )
    def securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ]
    def getSecurityConfigDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfigDetail", securityConfigDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse
  ) extends zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly {
    override val securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityConfigDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityConfigDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse
  ): zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly =
    new Wrapper(impl)
}
