package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait VolumeType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.VolumeType
}
object VolumeType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.VolumeType
  ): zio.aws.opensearch.model.VolumeType = value match {
    case software.amazon.awssdk.services.opensearch.model.VolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.VolumeType.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.opensearch.model.VolumeType.GP2 =>
      val r = gp2
      r
    case software.amazon.awssdk.services.opensearch.model.VolumeType.IO1 =>
      val r = io1
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.VolumeType =
      software.amazon.awssdk.services.opensearch.model.VolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.opensearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.VolumeType =
      software.amazon.awssdk.services.opensearch.model.VolumeType.STANDARD
  }
  case object gp2 extends zio.aws.opensearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.VolumeType =
      software.amazon.awssdk.services.opensearch.model.VolumeType.GP2
  }
  case object io1 extends zio.aws.opensearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.VolumeType =
      software.amazon.awssdk.services.opensearch.model.VolumeType.IO1
  }
}
