package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait UpgradeStep {
  def unwrap: software.amazon.awssdk.services.opensearch.model.UpgradeStep
}
object UpgradeStep {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.UpgradeStep
  ): zio.aws.opensearch.model.UpgradeStep = value match {
    case software.amazon.awssdk.services.opensearch.model.UpgradeStep.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStep.PRE_UPGRADE_CHECK =>
      val r = PRE_UPGRADE_CHECK
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStep.SNAPSHOT =>
      val r = SNAPSHOT
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStep.UPGRADE =>
      val r = UPGRADE
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.UpgradeStep {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStep =
      software.amazon.awssdk.services.opensearch.model.UpgradeStep.UNKNOWN_TO_SDK_VERSION
  }
  case object PRE_UPGRADE_CHECK extends zio.aws.opensearch.model.UpgradeStep {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStep =
      software.amazon.awssdk.services.opensearch.model.UpgradeStep.PRE_UPGRADE_CHECK
  }
  case object SNAPSHOT extends zio.aws.opensearch.model.UpgradeStep {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStep =
      software.amazon.awssdk.services.opensearch.model.UpgradeStep.SNAPSHOT
  }
  case object UPGRADE extends zio.aws.opensearch.model.UpgradeStep {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStep =
      software.amazon.awssdk.services.opensearch.model.UpgradeStep.UPGRADE
  }
}
