package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDomainConfigResponse(
    domainConfig: zio.aws.opensearch.model.DomainConfig,
    dryRunResults: Optional[zio.aws.opensearch.model.DryRunResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse = {
    import UpdateDomainConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse
      .builder()
      .domainConfig(domainConfig.buildAwsValue())
      .optionallyWith(dryRunResults.map(value => value.buildAwsValue()))(
        _.dryRunResults
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly =
    zio.aws.opensearch.model.UpdateDomainConfigResponse.wrap(buildAwsValue())
}
object UpdateDomainConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdateDomainConfigResponse =
      zio.aws.opensearch.model.UpdateDomainConfigResponse(
        domainConfig.asEditable,
        dryRunResults.map(value => value.asEditable)
      )
    def domainConfig: zio.aws.opensearch.model.DomainConfig.ReadOnly
    def dryRunResults: Optional[zio.aws.opensearch.model.DryRunResults.ReadOnly]
    def getDomainConfig
        : ZIO[Any, Nothing, zio.aws.opensearch.model.DomainConfig.ReadOnly] =
      ZIO.succeed(domainConfig)
    def getDryRunResults
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DryRunResults.ReadOnly] =
      AwsError.unwrapOptionField("dryRunResults", dryRunResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse
  ) extends zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly {
    override val domainConfig: zio.aws.opensearch.model.DomainConfig.ReadOnly =
      zio.aws.opensearch.model.DomainConfig.wrap(impl.domainConfig())
    override val dryRunResults
        : Optional[zio.aws.opensearch.model.DryRunResults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dryRunResults())
        .map(value => zio.aws.opensearch.model.DryRunResults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse
  ): zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
