package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{UIntValue, UpdateTimestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OptionStatus(
    creationDate: UpdateTimestamp,
    updateDate: UpdateTimestamp,
    updateVersion: Optional[UIntValue] = Optional.Absent,
    state: zio.aws.opensearch.model.OptionState,
    pendingDeletion: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.OptionStatus = {
    import OptionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.OptionStatus
      .builder()
      .creationDate(UpdateTimestamp.unwrap(creationDate): Instant)
      .updateDate(UpdateTimestamp.unwrap(updateDate): Instant)
      .optionallyWith(
        updateVersion.map(value => UIntValue.unwrap(value): Integer)
      )(_.updateVersion)
      .state(state.unwrap)
      .optionallyWith(pendingDeletion.map(value => value: java.lang.Boolean))(
        _.pendingDeletion
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.OptionStatus.ReadOnly =
    zio.aws.opensearch.model.OptionStatus.wrap(buildAwsValue())
}
object OptionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.OptionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.OptionStatus =
      zio.aws.opensearch.model.OptionStatus(
        creationDate,
        updateDate,
        updateVersion.map(value => value),
        state,
        pendingDeletion.map(value => value)
      )
    def creationDate: UpdateTimestamp
    def updateDate: UpdateTimestamp
    def updateVersion: Optional[UIntValue]
    def state: zio.aws.opensearch.model.OptionState
    def pendingDeletion: Optional[Boolean]
    def getCreationDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(creationDate)
    def getUpdateDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(updateDate)
    def getUpdateVersion: ZIO[Any, AwsError, UIntValue] =
      AwsError.unwrapOptionField("updateVersion", updateVersion)
    def getState: ZIO[Any, Nothing, zio.aws.opensearch.model.OptionState] =
      ZIO.succeed(state)
    def getPendingDeletion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pendingDeletion", pendingDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.OptionStatus
  ) extends zio.aws.opensearch.model.OptionStatus.ReadOnly {
    override val creationDate: UpdateTimestamp =
      zio.aws.opensearch.model.primitives.UpdateTimestamp(impl.creationDate())
    override val updateDate: UpdateTimestamp =
      zio.aws.opensearch.model.primitives.UpdateTimestamp(impl.updateDate())
    override val updateVersion: Optional[UIntValue] = zio.aws.core.internal
      .optionalFromNullable(impl.updateVersion())
      .map(value => zio.aws.opensearch.model.primitives.UIntValue(value))
    override val state: zio.aws.opensearch.model.OptionState =
      zio.aws.opensearch.model.OptionState.wrap(impl.state())
    override val pendingDeletion: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingDeletion())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.OptionStatus
  ): zio.aws.opensearch.model.OptionStatus.ReadOnly = new Wrapper(impl)
}
