package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait OpenSearchPartitionInstanceType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType
}
object OpenSearchPartitionInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType
  ): zio.aws.opensearch.model.OpenSearchPartitionInstanceType = value match {
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_MEDIUM_SEARCH =>
      val r = `m3.medium.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_LARGE_SEARCH =>
      val r = `m3.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_XLARGE_SEARCH =>
      val r = `m3.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_2_XLARGE_SEARCH =>
      val r = `m3.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_LARGE_SEARCH =>
      val r = `m4.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_XLARGE_SEARCH =>
      val r = `m4.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_2_XLARGE_SEARCH =>
      val r = `m4.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_4_XLARGE_SEARCH =>
      val r = `m4.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_10_XLARGE_SEARCH =>
      val r = `m4.10xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_LARGE_SEARCH =>
      val r = `m5.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_XLARGE_SEARCH =>
      val r = `m5.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_2_XLARGE_SEARCH =>
      val r = `m5.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_4_XLARGE_SEARCH =>
      val r = `m5.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_12_XLARGE_SEARCH =>
      val r = `m5.12xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_24_XLARGE_SEARCH =>
      val r = `m5.24xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_LARGE_SEARCH =>
      val r = `r5.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_XLARGE_SEARCH =>
      val r = `r5.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_2_XLARGE_SEARCH =>
      val r = `r5.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_4_XLARGE_SEARCH =>
      val r = `r5.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_12_XLARGE_SEARCH =>
      val r = `r5.12xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_24_XLARGE_SEARCH =>
      val r = `r5.24xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_LARGE_SEARCH =>
      val r = `c5.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_XLARGE_SEARCH =>
      val r = `c5.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_2_XLARGE_SEARCH =>
      val r = `c5.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_4_XLARGE_SEARCH =>
      val r = `c5.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_9_XLARGE_SEARCH =>
      val r = `c5.9xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_18_XLARGE_SEARCH =>
      val r = `c5.18xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_NANO_SEARCH =>
      val r = `t3.nano.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_MICRO_SEARCH =>
      val r = `t3.micro.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_SMALL_SEARCH =>
      val r = `t3.small.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_MEDIUM_SEARCH =>
      val r = `t3.medium.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_LARGE_SEARCH =>
      val r = `t3.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_XLARGE_SEARCH =>
      val r = `t3.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_2_XLARGE_SEARCH =>
      val r = `t3.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.ULTRAWARM1_MEDIUM_SEARCH =>
      val r = `ultrawarm1.medium.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.ULTRAWARM1_LARGE_SEARCH =>
      val r = `ultrawarm1.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.ULTRAWARM1_XLARGE_SEARCH =>
      val r = `ultrawarm1.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T2_MICRO_SEARCH =>
      val r = `t2.micro.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T2_SMALL_SEARCH =>
      val r = `t2.small.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T2_MEDIUM_SEARCH =>
      val r = `t2.medium.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_LARGE_SEARCH =>
      val r = `r3.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_XLARGE_SEARCH =>
      val r = `r3.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_2_XLARGE_SEARCH =>
      val r = `r3.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_4_XLARGE_SEARCH =>
      val r = `r3.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_8_XLARGE_SEARCH =>
      val r = `r3.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I2_XLARGE_SEARCH =>
      val r = `i2.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I2_2_XLARGE_SEARCH =>
      val r = `i2.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_XLARGE_SEARCH =>
      val r = `d2.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_2_XLARGE_SEARCH =>
      val r = `d2.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_4_XLARGE_SEARCH =>
      val r = `d2.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_8_XLARGE_SEARCH =>
      val r = `d2.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_LARGE_SEARCH =>
      val r = `c4.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_XLARGE_SEARCH =>
      val r = `c4.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_2_XLARGE_SEARCH =>
      val r = `c4.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_4_XLARGE_SEARCH =>
      val r = `c4.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_8_XLARGE_SEARCH =>
      val r = `c4.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_LARGE_SEARCH =>
      val r = `r4.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_XLARGE_SEARCH =>
      val r = `r4.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_2_XLARGE_SEARCH =>
      val r = `r4.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_4_XLARGE_SEARCH =>
      val r = `r4.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_8_XLARGE_SEARCH =>
      val r = `r4.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_16_XLARGE_SEARCH =>
      val r = `r4.16xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_LARGE_SEARCH =>
      val r = `i3.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_XLARGE_SEARCH =>
      val r = `i3.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_2_XLARGE_SEARCH =>
      val r = `i3.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_4_XLARGE_SEARCH =>
      val r = `i3.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_8_XLARGE_SEARCH =>
      val r = `i3.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_16_XLARGE_SEARCH =>
      val r = `i3.16xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_LARGE_SEARCH =>
      val r = `r6g.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_XLARGE_SEARCH =>
      val r = `r6g.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_2_XLARGE_SEARCH =>
      val r = `r6g.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_4_XLARGE_SEARCH =>
      val r = `r6g.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_8_XLARGE_SEARCH =>
      val r = `r6g.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_12_XLARGE_SEARCH =>
      val r = `r6g.12xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_LARGE_SEARCH =>
      val r = `m6g.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_XLARGE_SEARCH =>
      val r = `m6g.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_2_XLARGE_SEARCH =>
      val r = `m6g.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_4_XLARGE_SEARCH =>
      val r = `m6g.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_8_XLARGE_SEARCH =>
      val r = `m6g.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_12_XLARGE_SEARCH =>
      val r = `m6g.12xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_LARGE_SEARCH =>
      val r = `c6g.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_XLARGE_SEARCH =>
      val r = `c6g.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_2_XLARGE_SEARCH =>
      val r = `c6g.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_4_XLARGE_SEARCH =>
      val r = `c6g.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_8_XLARGE_SEARCH =>
      val r = `c6g.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_12_XLARGE_SEARCH =>
      val r = `c6g.12xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_LARGE_SEARCH =>
      val r = `r6gd.large.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_XLARGE_SEARCH =>
      val r = `r6gd.xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_2_XLARGE_SEARCH =>
      val r = `r6gd.2xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_4_XLARGE_SEARCH =>
      val r = `r6gd.4xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_8_XLARGE_SEARCH =>
      val r = `r6gd.8xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_12_XLARGE_SEARCH =>
      val r = `r6gd.12xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_16_XLARGE_SEARCH =>
      val r = `r6gd.16xlarge.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T4_G_SMALL_SEARCH =>
      val r = `t4g.small.search`
      r
    case software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T4_G_MEDIUM_SEARCH =>
      val r = `t4g.medium.search`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `m3.medium.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_MEDIUM_SEARCH
  }
  case object `m3.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_LARGE_SEARCH
  }
  case object `m3.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_XLARGE_SEARCH
  }
  case object `m3.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M3_2_XLARGE_SEARCH
  }
  case object `m4.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_LARGE_SEARCH
  }
  case object `m4.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_XLARGE_SEARCH
  }
  case object `m4.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_2_XLARGE_SEARCH
  }
  case object `m4.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_4_XLARGE_SEARCH
  }
  case object `m4.10xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M4_10_XLARGE_SEARCH
  }
  case object `m5.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_LARGE_SEARCH
  }
  case object `m5.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_XLARGE_SEARCH
  }
  case object `m5.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_2_XLARGE_SEARCH
  }
  case object `m5.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_4_XLARGE_SEARCH
  }
  case object `m5.12xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_12_XLARGE_SEARCH
  }
  case object `m5.24xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M5_24_XLARGE_SEARCH
  }
  case object `r5.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_LARGE_SEARCH
  }
  case object `r5.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_XLARGE_SEARCH
  }
  case object `r5.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_2_XLARGE_SEARCH
  }
  case object `r5.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_4_XLARGE_SEARCH
  }
  case object `r5.12xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_12_XLARGE_SEARCH
  }
  case object `r5.24xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R5_24_XLARGE_SEARCH
  }
  case object `c5.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_LARGE_SEARCH
  }
  case object `c5.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_XLARGE_SEARCH
  }
  case object `c5.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_2_XLARGE_SEARCH
  }
  case object `c5.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_4_XLARGE_SEARCH
  }
  case object `c5.9xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_9_XLARGE_SEARCH
  }
  case object `c5.18xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C5_18_XLARGE_SEARCH
  }
  case object `t3.nano.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_NANO_SEARCH
  }
  case object `t3.micro.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_MICRO_SEARCH
  }
  case object `t3.small.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_SMALL_SEARCH
  }
  case object `t3.medium.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_MEDIUM_SEARCH
  }
  case object `t3.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_LARGE_SEARCH
  }
  case object `t3.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_XLARGE_SEARCH
  }
  case object `t3.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T3_2_XLARGE_SEARCH
  }
  case object `ultrawarm1.medium.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.ULTRAWARM1_MEDIUM_SEARCH
  }
  case object `ultrawarm1.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.ULTRAWARM1_LARGE_SEARCH
  }
  case object `ultrawarm1.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.ULTRAWARM1_XLARGE_SEARCH
  }
  case object `t2.micro.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T2_MICRO_SEARCH
  }
  case object `t2.small.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T2_SMALL_SEARCH
  }
  case object `t2.medium.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T2_MEDIUM_SEARCH
  }
  case object `r3.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_LARGE_SEARCH
  }
  case object `r3.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_XLARGE_SEARCH
  }
  case object `r3.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_2_XLARGE_SEARCH
  }
  case object `r3.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_4_XLARGE_SEARCH
  }
  case object `r3.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R3_8_XLARGE_SEARCH
  }
  case object `i2.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I2_XLARGE_SEARCH
  }
  case object `i2.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I2_2_XLARGE_SEARCH
  }
  case object `d2.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_XLARGE_SEARCH
  }
  case object `d2.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_2_XLARGE_SEARCH
  }
  case object `d2.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_4_XLARGE_SEARCH
  }
  case object `d2.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.D2_8_XLARGE_SEARCH
  }
  case object `c4.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_LARGE_SEARCH
  }
  case object `c4.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_XLARGE_SEARCH
  }
  case object `c4.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_2_XLARGE_SEARCH
  }
  case object `c4.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_4_XLARGE_SEARCH
  }
  case object `c4.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C4_8_XLARGE_SEARCH
  }
  case object `r4.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_LARGE_SEARCH
  }
  case object `r4.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_XLARGE_SEARCH
  }
  case object `r4.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_2_XLARGE_SEARCH
  }
  case object `r4.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_4_XLARGE_SEARCH
  }
  case object `r4.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_8_XLARGE_SEARCH
  }
  case object `r4.16xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R4_16_XLARGE_SEARCH
  }
  case object `i3.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_LARGE_SEARCH
  }
  case object `i3.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_XLARGE_SEARCH
  }
  case object `i3.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_2_XLARGE_SEARCH
  }
  case object `i3.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_4_XLARGE_SEARCH
  }
  case object `i3.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_8_XLARGE_SEARCH
  }
  case object `i3.16xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.I3_16_XLARGE_SEARCH
  }
  case object `r6g.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_LARGE_SEARCH
  }
  case object `r6g.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_XLARGE_SEARCH
  }
  case object `r6g.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_2_XLARGE_SEARCH
  }
  case object `r6g.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_4_XLARGE_SEARCH
  }
  case object `r6g.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_8_XLARGE_SEARCH
  }
  case object `r6g.12xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_G_12_XLARGE_SEARCH
  }
  case object `m6g.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_LARGE_SEARCH
  }
  case object `m6g.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_XLARGE_SEARCH
  }
  case object `m6g.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_2_XLARGE_SEARCH
  }
  case object `m6g.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_4_XLARGE_SEARCH
  }
  case object `m6g.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_8_XLARGE_SEARCH
  }
  case object `m6g.12xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.M6_G_12_XLARGE_SEARCH
  }
  case object `c6g.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_LARGE_SEARCH
  }
  case object `c6g.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_XLARGE_SEARCH
  }
  case object `c6g.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_2_XLARGE_SEARCH
  }
  case object `c6g.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_4_XLARGE_SEARCH
  }
  case object `c6g.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_8_XLARGE_SEARCH
  }
  case object `c6g.12xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.C6_G_12_XLARGE_SEARCH
  }
  case object `r6gd.large.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_LARGE_SEARCH
  }
  case object `r6gd.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_XLARGE_SEARCH
  }
  case object `r6gd.2xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_2_XLARGE_SEARCH
  }
  case object `r6gd.4xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_4_XLARGE_SEARCH
  }
  case object `r6gd.8xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_8_XLARGE_SEARCH
  }
  case object `r6gd.12xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_12_XLARGE_SEARCH
  }
  case object `r6gd.16xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.R6_GD_16_XLARGE_SEARCH
  }
  case object `t4g.small.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T4_G_SMALL_SEARCH
  }
  case object `t4g.medium.search`
      extends zio.aws.opensearch.model.OpenSearchPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType.T4_G_MEDIUM_SEARCH
  }
}
