package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeToNodeEncryptionOptions(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions = {
    import NodeToNodeEncryptionOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly =
    zio.aws.opensearch.model.NodeToNodeEncryptionOptions.wrap(buildAwsValue())
}
object NodeToNodeEncryptionOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.NodeToNodeEncryptionOptions =
      zio.aws.opensearch.model
        .NodeToNodeEncryptionOptions(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions
  ) extends zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions
  ): zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly =
    new Wrapper(impl)
}
