package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListInstanceTypeDetailsResponse(
    instanceTypeDetails: Optional[
      Iterable[zio.aws.opensearch.model.InstanceTypeDetails]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse = {
    import ListInstanceTypeDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse
      .builder()
      .optionallyWith(
        instanceTypeDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeDetails)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly =
    zio.aws.opensearch.model.ListInstanceTypeDetailsResponse
      .wrap(buildAwsValue())
}
object ListInstanceTypeDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListInstanceTypeDetailsResponse =
      zio.aws.opensearch.model.ListInstanceTypeDetailsResponse(
        instanceTypeDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceTypeDetails
        : Optional[List[zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getInstanceTypeDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTypeDetails", instanceTypeDetails)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse
  ) extends zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly {
    override val instanceTypeDetails: Optional[
      List[zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTypeDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.InstanceTypeDetails.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse
  ): zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
