package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{NextToken, MaxResults, GUID}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstanceOfferingsRequest(
    reservedInstanceOfferingId: Optional[GUID] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest = {
    import DescribeReservedInstanceOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
      .builder()
      .optionallyWith(
        reservedInstanceOfferingId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedInstanceOfferingId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedInstanceOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest =
      zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest(
        reservedInstanceOfferingId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def reservedInstanceOfferingId: Optional[GUID]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getReservedInstanceOfferingId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedInstanceOfferingId",
        reservedInstanceOfferingId
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ) extends zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest.ReadOnly {
    override val reservedInstanceOfferingId: Optional[GUID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstanceOfferingId())
        .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.opensearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ): zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
