package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainResponse(
    domainStatus: Optional[zio.aws.opensearch.model.DomainStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreateDomainResponse
      .builder()
      .optionallyWith(domainStatus.map(value => value.buildAwsValue()))(
        _.domainStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CreateDomainResponse.ReadOnly =
    zio.aws.opensearch.model.CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreateDomainResponse =
      zio.aws.opensearch.model
        .CreateDomainResponse(domainStatus.map(value => value.asEditable))
    def domainStatus: Optional[zio.aws.opensearch.model.DomainStatus.ReadOnly]
    def getDomainStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      AwsError.unwrapOptionField("domainStatus", domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreateDomainResponse
  ) extends zio.aws.opensearch.model.CreateDomainResponse.ReadOnly {
    override val domainStatus
        : Optional[zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainStatus())
        .map(value => zio.aws.opensearch.model.DomainStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreateDomainResponse
  ): zio.aws.opensearch.model.CreateDomainResponse.ReadOnly = new Wrapper(impl)
}
