package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class CancelServiceSoftwareUpdateRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest = {
    import CancelServiceSoftwareUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest.ReadOnly =
    zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest
      .wrap(buildAwsValue())
}
object CancelServiceSoftwareUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest =
      zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest
  ) extends zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest
  ): zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
