package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AdvancedSecurityOptionsStatus(
    options: zio.aws.opensearch.model.AdvancedSecurityOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsStatus = {
    import AdvancedSecurityOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.wrap(buildAwsValue())
}
object AdvancedSecurityOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AdvancedSecurityOptionsStatus =
      zio.aws.opensearch.model
        .AdvancedSecurityOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.AdvancedSecurityOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.AdvancedSecurityOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsStatus
  ) extends zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.ReadOnly {
    override val options
        : zio.aws.opensearch.model.AdvancedSecurityOptions.ReadOnly =
      zio.aws.opensearch.model.AdvancedSecurityOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsStatus
  ): zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
