package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    arn: ARN,
    tagList: Iterable[zio.aws.opensearch.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AddTagsRequest
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AddTagsRequest.ReadOnly =
    zio.aws.opensearch.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AddTagsRequest =
      zio.aws.opensearch.model.AddTagsRequest(
        arn,
        tagList.map { item =>
          item.asEditable
        }
      )
    def arn: ARN
    def tagList: List[zio.aws.opensearch.model.Tag.ReadOnly]
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getTagList
        : ZIO[Any, Nothing, List[zio.aws.opensearch.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AddTagsRequest
  ) extends zio.aws.opensearch.model.AddTagsRequest.ReadOnly {
    override val arn: ARN = zio.aws.opensearch.model.primitives.ARN(impl.arn())
    override val tagList: List[zio.aws.opensearch.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.opensearch.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AddTagsRequest
  ): zio.aws.opensearch.model.AddTagsRequest.ReadOnly = new Wrapper(impl)
}
