package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.PolicyDocument
import scala.jdk.CollectionConverters._
final case class AccessPoliciesStatus(
    options: PolicyDocument,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AccessPoliciesStatus = {
    import AccessPoliciesStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AccessPoliciesStatus
      .builder()
      .options(PolicyDocument.unwrap(options): java.lang.String)
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AccessPoliciesStatus.ReadOnly =
    zio.aws.opensearch.model.AccessPoliciesStatus.wrap(buildAwsValue())
}
object AccessPoliciesStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AccessPoliciesStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AccessPoliciesStatus =
      zio.aws.opensearch.model.AccessPoliciesStatus(options, status.asEditable)
    def options: PolicyDocument
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[Any, Nothing, PolicyDocument] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AccessPoliciesStatus
  ) extends zio.aws.opensearch.model.AccessPoliciesStatus.ReadOnly {
    override val options: PolicyDocument =
      zio.aws.opensearch.model.primitives.PolicyDocument(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AccessPoliciesStatus
  ): zio.aws.opensearch.model.AccessPoliciesStatus.ReadOnly = new Wrapper(impl)
}
