package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait TimeUnit {
  def unwrap: software.amazon.awssdk.services.opensearch.model.TimeUnit
}
object TimeUnit {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.TimeUnit
  ): zio.aws.opensearch.model.TimeUnit = value match {
    case software.amazon.awssdk.services.opensearch.model.TimeUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.TimeUnit.HOURS =>
      val r = HOURS
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.TimeUnit =
      software.amazon.awssdk.services.opensearch.model.TimeUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object HOURS extends zio.aws.opensearch.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.TimeUnit =
      software.amazon.awssdk.services.opensearch.model.TimeUnit.HOURS
  }
}
