package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait OverallChangeStatus {
  def unwrap
      : software.amazon.awssdk.services.opensearch.model.OverallChangeStatus
}
object OverallChangeStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.OverallChangeStatus
  ): zio.aws.opensearch.model.OverallChangeStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.opensearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.PENDING
  }
  case object PROCESSING extends zio.aws.opensearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.PROCESSING
  }
  case object COMPLETED extends zio.aws.opensearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.COMPLETED
  }
  case object FAILED extends zio.aws.opensearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.opensearch.model.OverallChangeStatus.FAILED
  }
}
