package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{Password, Username, ARN}
import scala.jdk.CollectionConverters._
final case class MasterUserOptions(
    masterUserARN: Optional[ARN] = Optional.Absent,
    masterUserName: Optional[Username] = Optional.Absent,
    masterUserPassword: Optional[Password] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.MasterUserOptions = {
    import MasterUserOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.MasterUserOptions
      .builder()
      .optionallyWith(
        masterUserARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.masterUserARN)
      .optionallyWith(
        masterUserName.map(value => Username.unwrap(value): java.lang.String)
      )(_.masterUserName)
      .optionallyWith(
        masterUserPassword.map(value =>
          Password.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.MasterUserOptions.ReadOnly =
    zio.aws.opensearch.model.MasterUserOptions.wrap(buildAwsValue())
}
object MasterUserOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.MasterUserOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.MasterUserOptions =
      zio.aws.opensearch.model.MasterUserOptions(
        masterUserARN.map(value => value),
        masterUserName.map(value => value),
        masterUserPassword.map(value => value)
      )
    def masterUserARN: Optional[ARN]
    def masterUserName: Optional[Username]
    def masterUserPassword: Optional[Password]
    def getMasterUserARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("masterUserARN", masterUserARN)
    def getMasterUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("masterUserName", masterUserName)
    def getMasterUserPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.MasterUserOptions
  ) extends zio.aws.opensearch.model.MasterUserOptions.ReadOnly {
    override val masterUserARN: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserARN())
      .map(value => zio.aws.opensearch.model.primitives.ARN(value))
    override val masterUserName: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserName())
      .map(value => zio.aws.opensearch.model.primitives.Username(value))
    override val masterUserPassword: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => zio.aws.opensearch.model.primitives.Password(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.MasterUserOptions
  ): zio.aws.opensearch.model.MasterUserOptions.ReadOnly = new Wrapper(impl)
}
