package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{NextToken, MaxResults, PackageID}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetPackageVersionHistoryRequest(
    packageID: PackageID,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest = {
    import GetPackageVersionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.GetPackageVersionHistoryRequest.ReadOnly =
    zio.aws.opensearch.model.GetPackageVersionHistoryRequest
      .wrap(buildAwsValue())
}
object GetPackageVersionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.GetPackageVersionHistoryRequest =
      zio.aws.opensearch.model.GetPackageVersionHistoryRequest(
        packageID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def packageID: PackageID
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest
  ) extends zio.aws.opensearch.model.GetPackageVersionHistoryRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.opensearch.model.primitives.PackageID(impl.packageID())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.opensearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest
  ): zio.aws.opensearch.model.GetPackageVersionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
