package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class GetCompatibleVersionsRequest(
    domainName: Optional[DomainName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest = {
    import GetCompatibleVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.GetCompatibleVersionsRequest.ReadOnly =
    zio.aws.opensearch.model.GetCompatibleVersionsRequest.wrap(buildAwsValue())
}
object GetCompatibleVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.GetCompatibleVersionsRequest =
      zio.aws.opensearch.model
        .GetCompatibleVersionsRequest(domainName.map(value => value))
    def domainName: Optional[DomainName]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest
  ) extends zio.aws.opensearch.model.GetCompatibleVersionsRequest.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.opensearch.model.primitives.DomainName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest
  ): zio.aws.opensearch.model.GetCompatibleVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
