package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class Filter(
    name: Optional[NonEmptyString] = Optional.Absent,
    values: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.Filter
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.Filter.ReadOnly =
    zio.aws.opensearch.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.opensearch.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.Filter = zio.aws.opensearch.model
      .Filter(name.map(value => value), values.map(value => value))
    def name: Optional[NonEmptyString]
    def values: Optional[List[NonEmptyString]]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.Filter
  ) extends zio.aws.opensearch.model.Filter.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.opensearch.model.primitives.NonEmptyString(value))
    override val values: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.Filter
  ): zio.aws.opensearch.model.Filter.ReadOnly = new Wrapper(impl)
}
