package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{
  VersionString,
  DomainName,
  DomainId,
  ServiceUrl,
  PolicyDocument,
  ARN
}
import scala.jdk.CollectionConverters._
final case class DomainStatus(
    domainId: DomainId,
    domainName: DomainName,
    arn: ARN,
    created: Optional[Boolean] = Optional.Absent,
    deleted: Optional[Boolean] = Optional.Absent,
    endpoint: Optional[ServiceUrl] = Optional.Absent,
    endpoints: Optional[Map[String, ServiceUrl]] = Optional.Absent,
    processing: Optional[Boolean] = Optional.Absent,
    upgradeProcessing: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[VersionString] = Optional.Absent,
    clusterConfig: zio.aws.opensearch.model.ClusterConfig,
    ebsOptions: Optional[zio.aws.opensearch.model.EBSOptions] = Optional.Absent,
    accessPolicies: Optional[PolicyDocument] = Optional.Absent,
    snapshotOptions: Optional[zio.aws.opensearch.model.SnapshotOptions] =
      Optional.Absent,
    vpcOptions: Optional[zio.aws.opensearch.model.VPCDerivedInfo] =
      Optional.Absent,
    cognitoOptions: Optional[zio.aws.opensearch.model.CognitoOptions] =
      Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.opensearch.model.EncryptionAtRestOptions
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions
    ] = Optional.Absent,
    advancedOptions: Optional[Map[String, String]] = Optional.Absent,
    logPublishingOptions: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption
    ]] = Optional.Absent,
    serviceSoftwareOptions: Optional[
      zio.aws.opensearch.model.ServiceSoftwareOptions
    ] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.opensearch.model.DomainEndpointOptions
    ] = Optional.Absent,
    advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptions
    ] = Optional.Absent,
    autoTuneOptions: Optional[zio.aws.opensearch.model.AutoTuneOptionsOutput] =
      Optional.Absent,
    changeProgressDetails: Optional[
      zio.aws.opensearch.model.ChangeProgressDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DomainStatus = {
    import DomainStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DomainStatus
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .arn(ARN.unwrap(arn): java.lang.String)
      .optionallyWith(created.map(value => value: java.lang.Boolean))(_.created)
      .optionallyWith(deleted.map(value => value: java.lang.Boolean))(_.deleted)
      .optionallyWith(
        endpoint.map(value => ServiceUrl.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (ServiceUrl.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.endpoints)
      .optionallyWith(processing.map(value => value: java.lang.Boolean))(
        _.processing
      )
      .optionallyWith(upgradeProcessing.map(value => value: java.lang.Boolean))(
        _.upgradeProcessing
      )
      .optionallyWith(
        engineVersion.map(value =>
          VersionString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .clusterConfig(clusterConfig.buildAwsValue())
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(
        accessPolicies.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        logPublishingOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.logPublishingOptionsWithStrings)
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        changeProgressDetails.map(value => value.buildAwsValue())
      )(_.changeProgressDetails)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DomainStatus.ReadOnly =
    zio.aws.opensearch.model.DomainStatus.wrap(buildAwsValue())
}
object DomainStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DomainStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DomainStatus =
      zio.aws.opensearch.model.DomainStatus(
        domainId,
        domainName,
        arn,
        created.map(value => value),
        deleted.map(value => value),
        endpoint.map(value => value),
        endpoints.map(value => value),
        processing.map(value => value),
        upgradeProcessing.map(value => value),
        engineVersion.map(value => value),
        clusterConfig.asEditable,
        ebsOptions.map(value => value.asEditable),
        accessPolicies.map(value => value),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedOptions.map(value => value),
        logPublishingOptions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        serviceSoftwareOptions.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        changeProgressDetails.map(value => value.asEditable)
      )
    def domainId: DomainId
    def domainName: DomainName
    def arn: ARN
    def created: Optional[Boolean]
    def deleted: Optional[Boolean]
    def endpoint: Optional[ServiceUrl]
    def endpoints: Optional[Map[String, ServiceUrl]]
    def processing: Optional[Boolean]
    def upgradeProcessing: Optional[Boolean]
    def engineVersion: Optional[VersionString]
    def clusterConfig: zio.aws.opensearch.model.ClusterConfig.ReadOnly
    def ebsOptions: Optional[zio.aws.opensearch.model.EBSOptions.ReadOnly]
    def accessPolicies: Optional[PolicyDocument]
    def snapshotOptions
        : Optional[zio.aws.opensearch.model.SnapshotOptions.ReadOnly]
    def vpcOptions: Optional[zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly]
    def cognitoOptions
        : Optional[zio.aws.opensearch.model.CognitoOptions.ReadOnly]
    def encryptionAtRestOptions
        : Optional[zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ]
    def advancedOptions: Optional[Map[String, String]]
    def logPublishingOptions: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]]
    def serviceSoftwareOptions
        : Optional[zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly]
    def domainEndpointOptions
        : Optional[zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly]
    def advancedSecurityOptions
        : Optional[zio.aws.opensearch.model.AdvancedSecurityOptions.ReadOnly]
    def autoTuneOptions
        : Optional[zio.aws.opensearch.model.AutoTuneOptionsOutput.ReadOnly]
    def changeProgressDetails
        : Optional[zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getCreated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("created", created)
    def getDeleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getEndpoint: ZIO[Any, AwsError, ServiceUrl] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getEndpoints: ZIO[Any, AwsError, Map[String, ServiceUrl]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getProcessing: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("processing", processing)
    def getUpgradeProcessing: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("upgradeProcessing", upgradeProcessing)
    def getEngineVersion: ZIO[Any, AwsError, VersionString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getClusterConfig
        : ZIO[Any, Nothing, zio.aws.opensearch.model.ClusterConfig.ReadOnly] =
      ZIO.succeed(clusterConfig)
    def getEbsOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.EBSOptions.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getAccessPolicies: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.SnapshotOptions.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.CognitoOptions.ReadOnly] =
      AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getLogPublishingOptions: ZIO[Any, AwsError, Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AdvancedSecurityOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AutoTuneOptionsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getChangeProgressDetails: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("changeProgressDetails", changeProgressDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DomainStatus
  ) extends zio.aws.opensearch.model.DomainStatus.ReadOnly {
    override val domainId: DomainId =
      zio.aws.opensearch.model.primitives.DomainId(impl.domainId())
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val arn: ARN = zio.aws.opensearch.model.primitives.ARN(impl.arn())
    override val created: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => value: Boolean)
    override val deleted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleted())
      .map(value => value: Boolean)
    override val endpoint: Optional[ServiceUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.opensearch.model.primitives.ServiceUrl(value))
    override val endpoints: Optional[Map[String, ServiceUrl]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.opensearch.model.primitives
                .ServiceUrl(value)
            })
            .toMap
        )
    override val processing: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.processing())
      .map(value => value: Boolean)
    override val upgradeProcessing: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.upgradeProcessing())
      .map(value => value: Boolean)
    override val engineVersion: Optional[VersionString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.opensearch.model.primitives.VersionString(value))
    override val clusterConfig
        : zio.aws.opensearch.model.ClusterConfig.ReadOnly =
      zio.aws.opensearch.model.ClusterConfig.wrap(impl.clusterConfig())
    override val ebsOptions
        : Optional[zio.aws.opensearch.model.EBSOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptions())
        .map(value => zio.aws.opensearch.model.EBSOptions.wrap(value))
    override val accessPolicies: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value => zio.aws.opensearch.model.primitives.PolicyDocument(value))
    override val snapshotOptions
        : Optional[zio.aws.opensearch.model.SnapshotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotOptions())
        .map(value => zio.aws.opensearch.model.SnapshotOptions.wrap(value))
    override val vpcOptions
        : Optional[zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.opensearch.model.VPCDerivedInfo.wrap(value))
    override val cognitoOptions
        : Optional[zio.aws.opensearch.model.CognitoOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoOptions())
        .map(value => zio.aws.opensearch.model.CognitoOptions.wrap(value))
    override val encryptionAtRestOptions
        : Optional[zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAtRestOptions())
        .map(value =>
          zio.aws.opensearch.model.EncryptionAtRestOptions.wrap(value)
        )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.opensearch.model.NodeToNodeEncryptionOptions.wrap(value)
      )
    override val advancedOptions: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val logPublishingOptions: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.opensearch.model.LogType.wrap(
              key
            ) -> zio.aws.opensearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val serviceSoftwareOptions
        : Optional[zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSoftwareOptions())
        .map(value =>
          zio.aws.opensearch.model.ServiceSoftwareOptions.wrap(value)
        )
    override val domainEndpointOptions
        : Optional[zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainEndpointOptions())
        .map(value =>
          zio.aws.opensearch.model.DomainEndpointOptions.wrap(value)
        )
    override val advancedSecurityOptions
        : Optional[zio.aws.opensearch.model.AdvancedSecurityOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedSecurityOptions())
        .map(value =>
          zio.aws.opensearch.model.AdvancedSecurityOptions.wrap(value)
        )
    override val autoTuneOptions
        : Optional[zio.aws.opensearch.model.AutoTuneOptionsOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneOptions())
        .map(value =>
          zio.aws.opensearch.model.AutoTuneOptionsOutput.wrap(value)
        )
    override val changeProgressDetails
        : Optional[zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressDetails())
        .map(value =>
          zio.aws.opensearch.model.ChangeProgressDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DomainStatus
  ): zio.aws.opensearch.model.DomainStatus.ReadOnly = new Wrapper(impl)
}
