package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeOutboundConnectionsResponse(
    connections: Optional[
      Iterable[zio.aws.opensearch.model.OutboundConnection]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse = {
    import DescribeOutboundConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeOutboundConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeOutboundConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeOutboundConnectionsResponse =
      zio.aws.opensearch.model.DescribeOutboundConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connections
        : Optional[List[zio.aws.opensearch.model.OutboundConnection.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.OutboundConnection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse
  ) extends zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly {
    override val connections
        : Optional[List[zio.aws.opensearch.model.OutboundConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.OutboundConnection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse
  ): zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
