package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.VersionString
import scala.jdk.CollectionConverters._
final case class CompatibleVersionsMap(
    sourceVersion: Optional[VersionString] = Optional.Absent,
    targetVersions: Optional[Iterable[VersionString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap = {
    import CompatibleVersionsMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap
      .builder()
      .optionallyWith(
        sourceVersion.map(value =>
          VersionString.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .optionallyWith(
        targetVersions.map(value =>
          value.map { item =>
            VersionString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetVersions)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CompatibleVersionsMap.ReadOnly =
    zio.aws.opensearch.model.CompatibleVersionsMap.wrap(buildAwsValue())
}
object CompatibleVersionsMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CompatibleVersionsMap =
      zio.aws.opensearch.model.CompatibleVersionsMap(
        sourceVersion.map(value => value),
        targetVersions.map(value => value)
      )
    def sourceVersion: Optional[VersionString]
    def targetVersions: Optional[List[VersionString]]
    def getSourceVersion: ZIO[Any, AwsError, VersionString] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getTargetVersions: ZIO[Any, AwsError, List[VersionString]] =
      AwsError.unwrapOptionField("targetVersions", targetVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap
  ) extends zio.aws.opensearch.model.CompatibleVersionsMap.ReadOnly {
    override val sourceVersion: Optional[VersionString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => zio.aws.opensearch.model.primitives.VersionString(value))
    override val targetVersions: Optional[List[VersionString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.primitives.VersionString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap
  ): zio.aws.opensearch.model.CompatibleVersionsMap.ReadOnly = new Wrapper(impl)
}
